﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Tutti i dati raccolti durante l'attivazione del prodotto vengono utilizzati nel rispetto dell'Informativa sulla privacy di Autodesk. ";
var xmsgOfflinePrivacyWarning= "Se non si è connessi a Internet, impostare la codifica del browser Internet Explorer® su Selezione automatica, in modo da visualizzare l’informativa sulla privacy. Se è possibile accedere a Internet, l’informativa sulla privacy sarà inoltre disponibile in linea presso il sito Web autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"it";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Autorizzazione confermata";
var xmsgRTActLicFound=                  "Trovata licenza attivata";
var xmsgRTActLicFoundError=            "Errore di registrazione - attivazione"; 
var xmsgRTAuthEntryError=				"Errore di immissione attivazione";
var xmsgRTAuthError=					"Errore di attivazione";
var xmsgRTAuthNow=						"Autorizza ora";
var xmsgRTBeginReg=						"Inizio registrazione";
var xmsgRTBuyInformation=				"Informazioni di acquisto";
var xmsgRTConfirm=						"Conferma utente";
var xmsgRTConnect=						"Connessione";
var xmsgRTConnectFail=					"Errore di connessione";
var xmsgRTContactAutodesk=				"Contattare Autodesk";
var xmsgRTCountryPage=					"Paese";
var xmsgRTEmail=						"E-mail";
var xmsgRTFaxUS=						"Fax utente";
var xmsgRTMailUS=						"Indirizzo postale utente";
var xmsgRTPurchaseOffline=				"Acquisto non in linea";
var xmsgRTRegConfirmed=					"Registrazione confermata";
var xmsgRTExportConfirm=                "Conferma esportazione licenza";
var xmsgRTImportConfirm=                "Conferma importazione licenza"; 
var xmsgRTRegVol=						"Registra prodotto";
var xmsgRTSUNDataConfirm=				"Conferma SUN Data";
var xmsgRTSUNServer=					"Server SUN";
var xmsgRTSUNSubmit=					"Conferma utente/Invia SUN";
var xmsgRTUserInfo=						"Informazioni utente";
var xmsgRTLicFileSaveError=				"Errore di salvataggio del file di licenza Flexlm";
var xmsgRTProductInfo=                   "Informazioni sul prodotto"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"Ottenere una licenza di rete";
var xmsgNSARTLocateLicense=				"Individuare il file di licenza";
var xmsgNSARTEditServerAndSeat=			"Immettere o modificare le informazioni server";
var xmsgNSARTConfirmServerAndSeat=		"Confermare le informazioni server";
var xmsgNSARTEnterSN=					"Immettere il numero di serie";
var xmsgProcessingError=				"Errore di elaborazione";
var xmsgTimeout=        				"Sessione scaduta";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Attivazione di:";
var xmsgPurchase=       "Acquisto:";
var xmsgRegistrationFor=       "Registrazione di:";
var xmsgProduct=	"Prodotto: ";
var xmsgsernum=		"Numero di serie: ";
var xmsgsernumWGID=	"Numero di serie o ID gruppo: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Chiave di prodotto: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Numero di serie precedente: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Numero di serie precedente:*";
var xmsgNewSernum1=	"Immettere il numero di serie o l'ID gruppo:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Codice di richiesta: ";
var xmsgRegAuthCode=	"Codice di attivazione: ";
var xmsgApplicationKey=	"Codice applicazione: ";
var xmsgRTHostID=				"ID host:";
var xmsgRTFlexlmLicenseFile=	"File di licenza:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Titolo:";
var xmsgNone=		"(nessuno)";
var xmsgNotEntered=	"(non digitato)";
var xmsgFirstname=	"Nome:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Nome (Kanji):";
var xmsgFirstnameFurigana=	"Nome (Zenkaku Kana):";
var xmsgLastname=	"Cognome:";
var xmsgLastnameKanji=	"Cognome (Kanji):";
var xmsgLastnameFurigana=	"Cognome (Zenkaku Kana):";
var xmsgCompanyName=	"Società:*";
var xmsgCompanyName2=	"Società:";
var xmsgCompanyNameJP=	"Nome società (Kanji):";
var xmsgPhone=		"Telefono:";
var xmsgArea=		"Area:";
var xmsgNumber=		"Numero:";
var xmsgExt=		"Interno:";
var xmsgFax=		"Fax:";
var xmsgFaxTo=		"Invia fax a ";
var xmsgEmail=		"E-mail:";
var xmsgEmailTo=	"Invia e-mail a ";
var xmsgAddress=	"Indirizzo:";
var xmsgAddress2=	"Indirizzo 2:";
var xmsgAddress3=	"Indirizzo 3:";
var xmsgJPAddress=	"Città:";
var xmsgJPAddress2=	"Indirizzo:";
var xmsgJPAddress3=	"Nome edificio (e numero suite):";
var xmsgCity=		"Città:";
var xmsgSRP=		"Stato/Regione/Provincia:";
var xmsgStText=		"Stato:";
var xmsgPrText=		"Provincia:";
var xmsgRegText=	"Regione:";
var xmsgPrefectureText=	"Prefettura:";
var xmsgCountyText=	"Provincia:";
var xmsgCantonText=	"Cantone:";
var xmsgZipCode=	"Codice di avviamento postale:";
var xmsgPostCode=	"Codice di avviamento postale:";
var xmsgCountry=	"Paese o regione:";
var xmsgDealer=		"Rivenditore autorizzato Autodesk:";
var xmsgMailTo=		"Invia posta a ";
var xmsgAnEmail=	"un indirizzo e-mail";
var xmsgAFax=		"un numero di fax";
var xmsgAMailAddress=	"un indirizzo postale";
var xmsgPostalMail=		"Posta ordinaria";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< Indietro";
var xmsgCancel=			"Chiudi";
var xmsgNext=			"Avanti >>";
var xmsgPrint=			"Stampa";
var xmsgPrintForm=		"Apri modulo di richiesta di attivazione";
var xmsgNo=				"No";
var xmsgYes=			"Sì";
var xmsgBrowse=			"Sfoglia";
var xmsgDone=			"Operazione completata";
var xmsgOK=				"OK";
var xmsgClose=			"Chiudi";
var xmsgSubmit=			"Invia";
var xmsgFinish=			"Fine";
var xmsgReset=			"Elimina tutto";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Selezionare ";
var xmsgPleaseSelect2=		"Selezionare un'opzione e fare clic su Avanti";
var xmsgSelectCountry=		"Paese/regione in cui verrà utilizzato il prodotto:";
var xmsgSelectCountry2=		"Paese/regione:";
var xmsgInformation=		"Informazioni";
var xmsgCompanyInfo=		"Informazioni relative alla società:";
var xmsgContactInfo=		"Chi contattare:";
var xmsgResponseMethodInfo=	"Informazioni sul metodo di risposta:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Metodo di invio del modulo:";
var xmsgConfirmInfo=		"Conferma informazioni";
var xmsgConfirmInfoTxt=		"Controllare che le informazioni seguenti siano corrette. Fare clic su uno dei collegamenti relativi al metodo di invio del modulo per continuare, utilizzando le informazioni visualizzate o fare clic su Indietro per apportare modifiche.";
var xmsgConfirmCustIDInfoTxt=		"Confermare le seguenti informazioni. Fare clic su Avanti per continuare o su Indietro per apportare modifiche.";
var xmsgCountryHdr=			"Registrazione del prodotto";
var xmsgCountryRegTo=		"Questo prodotto verrà registrato a nome di:";
var xmsgCountryComp=		"Società";
var xmsgCountryIndiv=		"Utente";
var xmsgCountryUpgrade=		"Questo è un aggiornamento";
var xmsgCountryUpgDetail=	"(Se si è un cliente Autodesk Subscription, fare clic su No)";
var xmsgConnectHdr1=		"Connessione in corso";
var xmsgConnectHdr=		"Connessione a Internet";
var xmsgConnectMsg=		"Connessione";
var xmsgConnectTxt=		"Nessuna connessione a Internet rilevata. Per inviare una richiesta in linea, stabilire una connessione a Internet.";
var xmsgConnectTxtOLT=    "Non è stata rilevata alcuna connessione a Internet. Per trasferire la licenza, effettuare la connessione a Internet.";
var xmsgConnectTxt2=	"Una volta stabilito il collegamento, fare clic su Avanti.";
var xmsgConnectTxt3=	"Per inviare la richiesta con un metodo diverso, fare clic sul seguente collegamento:";
var xmsgConnectWarming=	"L'invio delle informazioni potrebbe richiedere alcuni minuti. Attendere.";
var xmsgTryAgain=		"Riprovare";
var xmsgReEnterOld=		"Immettere di nuovo il numero di serie precedente";
var xmsgNewSernum3=		"Immettere il nuovo numero di serie e fare clic su Avanti.";
var xmsgNewSernum4=		"Il software di valutazione è stato installato con il numero di serie 000-00000000, che non può essere registrato. Quando si acquista una copia del software viene fornito un nuovo numero di serie. Per attivare e abilitare il prodotto, è necessario utilizzare tale numero.";
var xmsgNewSernum5=		"Immettere il numero di serie o l'ID gruppo:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Immettere la chiave di prodotto:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Conferma nuovo numero di serie:";
var xmsgNewSernum8=		"Immettere di nuovo il nuovo numero di serie";
var xmsgUseOtherMethod=		"Utilizzare un altro metodo di registrazione";
var xmsgContactAutodesk=	"Contattare Autodesk";
var xmsgContactAutodeskLink="Per contattare Autodesk, fare clic sul seguente collegamento:";
var xmsgContactOptions=		"- per contattare Autodesk, utilizzare uno dei metodi riportati di seguito.";

var xmsgPuchaseInfo1=		"Informazioni di acquisto";
var xmsgPuchaseInfo2=		"È stata selezionata la procedura di acquisto in linea."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Fare clic su Avanti per continuare o su Esci per interrompere la procedura."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Registrazione - Attivazione";
var xmsgRegTitleBuy=		"Acquistare i prodotti Autodesk in linea";
var xmsgRegTitleNSA=		"Attivazione licenza di rete";
var xmsgRegInfo=		"Informazioni sul cliente";
var xmsgRegInfo2=		"Metodo di registrazione";
var xmsgRegInfo3=		"Selezionare un metodo di registrazione e fare clic su Avanti.";
var xmsgRegmethod1=		"Collegamento diretto tramite Internet";
var xmsgRegmethod3=		"Desidero ricevere il codice di attivazione mediante:";
var xmsgRegmethod5=		"Posta";
var xmsgRegmethod6=		"Fare clic sul pulsante Stampa di seguito e inviare il modulo a:";
var xmsgRegmethod7=		"Fax";
var xmsgRegmethod8=		"Per stampare una copia del modulo da inviare via fax ad Autodesk al numero %1, scegliere il metodo di ricezione del codice di attivazione, quindi fare clic su Stampa. In seguito sarà possibile inviare il modulo via fax.";
var xmsgRegmethod9=		"E-mail";
var xmsgRegmethod10NSA=		"Le informazioni relative alla registrazione e al server delle licenze, mostrate di seguito, sono state salvate automaticamente in un file.";
var xmsgRegmethod10=		"Le informazioni relative alla registrazione sono state salvate nel seguente file, che verrà utilizzato per completare la procedura via e-mail (non modificare il file):";
var xmsgRegmethod11NSA=		"Inviare via e-mail il file di informazioni sulla registrazione e sul server delle licenze %1 a %2.";
var xmsgRegmethod11=		"Inviare via e-mail il file di informazioni sulla registrazione %1 a %2.";
var xmsgRegmethod12=		"Non modificare il file.<p>Si consiglia inoltre di stampare questa pagina e conservarne una copia in luogo sicuro. Le informazioni che vi sono contenute saranno necessarie per completare manualmente il processo di invio tramite e-mail. È possibile stampare una copia delle informazioni per i record, quindi fare clic su Operazione completata per chiudere l'applicazione.";
var xmsgRegmethod13=		"Per allegare e inviare automaticamente %1 ad Autodesk, fare clic sul seguente collegamento.";
var xmsgRegmethod14=		"Invia la richiesta tramite e-mail";
var xmsgRegmethod15=		"Nota: l'indirizzo e-mail è automatizzato. Non inviare altre comunicazioni a questo indirizzo.";
var xmsgRegmethod16=		"Per eseguire la registrazione via fax o posta, fare clic su uno dei seguenti collegamenti:";
var xmsgRegmethod17=		"Errore durante l'invio del messaggio e-mail";
var xmsgRegmethod18NSA=		"Errore durante il tentativo di invio automatico delle informazioni sulla registrazione e sul server delle licenze.";
var xmsgRegmethod18=		"Errore durante il tentativo di invio automatico delle informazioni sulla registrazione.";
var xmsgRegmethod19=		"Per inviare manualmente il file tramite e-mail:";
var xmsgRegmethod20NSA=		"Inviare via e-mail il file delle informazioni sulla registrazione e sul server delle licenze %1 a %2.";
var xmsgRegmethod20=		"Inviare via e-mail il file delle informazioni sulla registrazione %1 a %2.";
var xmsgRegmethod21=		"Non modificare il file.<p>Si consiglia inoltre di stampare questa pagina e conservarne una copia in luogo sicuro. Le informazioni che vi sono contenute saranno necessarie per completare manualmente il processo di invio tramite e-mail. È possibile stampare una copia delle informazioni per i record, quindi fare clic su Operazione completata per chiudere l'applicazione.";
var xmsgRegAuthInfo=		"Attivazione";
var xmsgRegAuthInfo1=		"Conferma registrazione";
var xmsgRegExpConfirm=      "Conferma esportazione licenza";
var xmsgRegImpConfirm=      "Conferma importazione licenza";
var xmsgRegAuthInfo2=		"Ottenere un codice di attivazione";
var xmsgRegAuthInfo3=		"Immettere il codice di attivazione"; 
var xmsgRegAuthInfo4=		"Selezionare un'opzione tra quelle riportate di seguito:";
var xmsgRegAuthInfo4A=		"Immettere un codice di attivazione";
var xmsgRegAuthInfo4B=		"Immettere il codice di attivazione:"; 
var xmsgRegAuthInfo5=		"Selezionare un paese o regione, immettere il codice di attivazione e fare clic su Avanti.";
var xmsgRegAuthInfo6=		"Conferma registrazione - attivazione";	
var xmsgRegAuthInfo7=		"Grazie per aver effettuato la registrazione e l'attivazione del prodotto.";
var xmsgRegAuthInfo8=		"Conferma";		
var xmsgRegAuthInfo9=		"Grazie per effettuare la registrazione del prodotto Autodesk acquistato. Ciò ci consentirà di fornire un servizio migliore in futuro.";
var xmsgRegAuthInfo10=		"Una copia delle informazioni di registrazione è stata salvata in:";		
var xmsgRegAuthInfo10B=		"Una copia delle informazioni di registrazione è stata salvata in:";
var xmsgRegActLicInfo=      "Trovata licenza attivata";
var xmsgRegActLicInfoError=      "Errore di registrazione - attivazione";
var xmsgRegActiveInfo=        "Immettere o selezionare il file di attivazione:";
var xmsgRegActLicInfo1=       "Sul computer è stata rilevata una licenza per questo prodotto già registrata e attivata. Grazie."
var xmsgRegActLicInfo1Error= "Sul computer è stata rilevata una licenza per questo prodotto già registrata e attivata.\n Si è verificato tuttavia un errore imprevisto (%1). Chiudere l'applicazione e riprovare. Se il problema persiste, contattare l'amministratore di sistema o il fornitore di prodotti autorizzato Autodesk.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Esportazione completata"; //2008-01-16
var xmsgExportFail=           "Richiesta di esportazione non riuscita" ; //2008-01-16
var xmsgRegErrRef=            "Riferimento errore:"; //2008-01-17
var xmsgImportSuccess=        "Importazione completata"; //2008-01-16
var xmsgImportFail=           "Richiesta di importazione non riuscita"; //2008-01-16
var xmsgExpSucessInfo=        "La licenza è stata esportata e ora si trova sul server Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Come importare la licenza";
var xmsgExpSucessInfo1=        "Prima di avviare il prodotto sul computer di destinazione, utilizzare l'Utilità di trasferimento licenze per importare la licenza sul computer e prepararsi ad immettere i propri ID utente e password Autodesk.";  //2008-01-16
var xmsgImpSucessInfo=         "La licenza è stata importata, ora è possibile utilizzare il prodotto. "; //2008-01-16
var xmsgImpRemindInfo=         "Ricordami di eseguire l'esportazione."; //2008-01-16
var xmsgImpRemindInfo1=        "Selezionando questa casella, verrà visualizzata una finestra di dialogo all'uscita dal programma che ricorderà di eseguire l'esportazione della licenza.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Tale funzione risulta utile se la licenza è stata importata temporaneamente su questo computer ed è necessario trasferirla nuovamente al computer di origine.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "Nel promemoria è disponibile l'opzione \"Non visualizzare questa finestra in futuro\".";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Fare clic sul collegamento \"Riprovare\" per inviare nuovamente la richiesta. ";
var xmsgImpFailMsg=            "Se il problema persiste, si consiglia di attivare la licenza invece di importarla.";

var xmsgReqfilelocMsg=       "Il file di richiesta si trova in:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Grazie per aver effettuato la registrazione. Ora il prodotto è attivato e il file di licenza è stato salvato. Se si desidera conservare queste informazioni, fare clic su Stampa.";
var xmsgRegAuthInfo12=		"Incollare il codice di attivazione.";
var xmsgRegAuthInfo13=		"Digitare il codice di attivazione.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Immettere il codice di attivazione per continuare.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Codice di attivazione non valido. Verificare la presenza di errori nel codice.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Immettere il percorso e il nome del file di attivazione per continuare.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Immettere il numero di serie per continuare.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Numero di serie troppo breve.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Immettere la chiave di prodotto per continuare.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>Chiave di prodotto troppo breve.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Errore di registrazione - attivazione";
var xmsgRegErrorSystem=		"Un problema temporaneo del sistema provoca errori nella registrazione. Fare clic su uno dei seguenti collegamenti."
var xmsgRegErrorPrevReg=	"Il numero di serie immesso è già registrato.";
var xmsgRegErrorMaxAuth=	"È stato superato il numero massimo di attivazioni consentite per questo prodotto.";
var xmsgRegErrorMaxAuth2=	"È stato superato il numero massimo di licenze consentite per questo prodotto.";
var xmsgRegErrorInvalidOld=	"Il numero di serie immesso per il prodotto precedente non è valido. Verificare che il numero di serie precedente visualizzato sia corretto. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegErrorData=		"Si è verificato un problema con le informazioni di registrazione immesse. Per continuare, selezionare Riprovare per esaminare e correggere le informazioni immesse, utilizzare un metodo di registrazione diverso oppure contattare Autodesk.";
var xmsgRegErrorNetwork=	"Il prodotto che si sta tentando di registrare è autorizzato all'uso in rete e deve essere installato come tale. È necessario disinstallare il software e selezionare \"Rete\" come tipo di installazione.<p>Per informazioni sulle procedure di installazione e di attivazione relative alla versione per rete, vedere l'apposita sezione nel Manuale di installazione.";
var xmsgRegNoResponse=		"Un problema temporaneo provoca errori nella registrazione in linea. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegErrorAuthEntry=	"Si è verificato un problema con il codice di attivazione immesso. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegErrorAuthPermission = "Per attivare questo prodotto Autodesk, è necessario disporre dei diritti di amministratore oppure ottenere diritti di livello elevato dall'amministratore di sistema. Rivolgersi all'amministratore di sistema per ulteriori informazioni sui diritti.";							
var xmsgRegErrorAuth=		"Si è verificato un problema con il codice di attivazione. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegErrorFlex=		"Si è verificato un problema con la licenza. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegConnError=		"Errore di connessione";
var xmsgRegConnErrorTxt=	"Si è verificato un problema con la connessione Internet. Fare clic su uno dei seguenti collegamenti.";
var xmsgRegPurchError3=		"Utilizzare un altro metodo di acquisto";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Grazie per aver scelto di acquistare il software Autodesk.<p>Al momento non è disponibile una connessione per completare il processo, probabilmente a causa delle impostazioni del sistema.<p>Per ritentare la connessione, aprire il browser facendo clic su uno dei collegamenti riportati di seguito.<p>";

var xmsgAuthResellerMsg1=	"Acquisto dal proprio rivenditore locale. Per completare l'acquisto, contattare il proprio rivenditore locale.";

var xmsgLicSaveErrInfo=		"Si è verificato un errore durante il salvataggio del file di licenza. Fare clic su uno dei seguenti collegamenti.";

var xmsgOnlineStoreMsg1=	"Acquisto presso il negozio in linea di Autodesk. Se il prodotto che si sta cercando non è disponibile nel negozio in linea, contattare un rivenditore autorizzato.";
var xmsgOnlineStoreMsg2=    "Negozio in linea";
var xmsgAuthResellerMsg2=	"Rivenditore autorizzato";
var xmsgLocateLicenseMsg1=	"Individuare il file di licenza";
var xmsgLocateLicenseMsg2=	"Immettere un percorso per il file di licenza (o utilizzare Sfoglia per cercarne uno), quindi fare clic su Avanti per continuare.";
var xmsgLocateLicenseMsg3=	"File di licenza esistente:";
var xmsgUserContactMsg=		"È necessario digitare almeno una delle seguenti informazioni:";
var xmsgFailureMsg=		    "Impossibile elaborare la richiesta di attivazione in linea.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Si è verificato un errore (%1) che impedisce l'elaborazione della richiesta di attivazione in linea mediante i sistemi automatizzati.";
var xmsgRegErrorOnline=		"Fare clic sul collegamento \"Utilizzare un altro metodo\" di seguito per completare i moduli necessari e inviare la richiesta all'Autodesk Business Center più vicino. Un rappresentante del servizio clienti risponderà entro 2 giorni lavorativi.";
var xmsgAnotherFormSubmitMethod=    "Utilizzare un altro metodo";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Richiesta di attivazione in linea scaduta."
var xmsgTimeoutMsg2=    "Fare clic sul collegamento \"Riprovare\" per inviare nuovamente la richiesta in linea. Se il problema persiste, fare clic sul collegamento \"Utilizzare un altro metodo\" per completare i moduli necessari e inviare la richiesta mediante posta elettronica, fax o per le altre opzioni.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Dati relativi alla registrazione salvati";
var xmsgRegSunData2=		"I dati relativi alla registrazione richiesti per l'installazione client sono stati salvati in ";
var xmsgRegSunData3=		"Il numero di serie precedente specificato per la registrazione dell'aggiornamento non è valido. Contattare l'amministratore.";
var xmsgRegSunData4=		"È necessario installare nuovamente il software specificando un numero di serie precedente valido.";
var xmsgRegSunData5=		"Installazione su rete per singolo utente";
var xmsgRegSunData6=		"Per completare l'installazione su rete per singolo utente sul server, è necessario specificare alcune informazioni relative alla registrazione. Utilizzare le pagine seguenti per:";
var xmsgRegSunData7=		"Raccogliere le informazioni richieste.";
var xmsgRegSunData8=		"Immettere il numero di serie precedente, se richiesto per un aggiornamento.";
var xmsgRegSunData9=		"Memorizzare le informazioni sul server per la distribuzione di tutte le installazioni client.";
var xmsgRegSunData10=		"Il software verrà registrato utilizzando le informazioni seguenti. Per continuare, fare clic su Avanti.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Registrazione del prodotto";
var xmsgRegVol2=	"Selezionare un'opzione e fare clic su Avanti:";
var xmsgRegVol3=	"Registra ora: selezionare questa opzione per avviare la procedura di registrazione in linea";
var xmsgRegVol4=	"Registra in un momento successivo: selezionare questa opzione per eseguire subito il software";
var xmsgRegVol5=	"Non visualizzare questa finestra in futuro.";
var xmsgRegVol6=	"(Se si desidera eseguire la registrazione in un momento successivo, è possibile selezionare l'apposita opzione in ?|finestra di dialogo Informazioni su)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identificazione cliente";
var xmsgKatakana=		    "Nome società (Zenkaku Kana):";
var xmsgDepartment=		    "Reparto:";
var xmsgDepartment2=		"Nome reparto:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Su Internet:";
var xmsgFormWebDataMsg1= "È inoltre possibile ottenere un codice di attivazione visitando:<br>";
var xmsgFormEmailHdr=	"E-mail:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Fax:";
var xmsgFormFaxHdrLocal=	"Fax a ufficio locale:";
var xmsgFormFaxHdrReg=	"Registrazione via fax:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Telefono:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Posta ordinaria:";
var xmsgFormMailHdrLocal=	"Posta a ufficio locale:";
var xmsgFormMailHdrReg=	"Registrazione via posta:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Acquista software";
var xmsgFormInternetMsg=    "Per utilizzare il browser Web per la richiesta del codice di attivazione, fare clic sul collegamento."
var xmsgFormEmailMsg=       "Inviare la corrispondenza e le richieste di attivazione tramite posta elettronica a:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Le informazioni fornite verranno utilizzate da Autodesk per registrare e/o emettere il codice di attivazione. La registrazione conferma il consenso all'invio delle informazioni sull'utente da parte di Autodesk ai business partner autorizzati per la gestione delle licenze del prodotto e a scopo di verifica delle autorizzazioni. Contattare Autodesk all'indirizzo <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> se si desidera che le proprie informazioni non vengano condivise con i business partner autorizzati per tali fini. Per correggere o aggiornare i dati di registrazione, fare clic <a %1>QUI</a> per contattare Autodesk oppure contattare l'ufficio Autodesk locale.";
			
var privacystatement = "Le informazioni fornite verranno utilizzate da Autodesk per registrare e/o emettere il codice di attivazione, per inviare informazioni in merito ai prodotti e servizi e per garantire tutti i vantaggi previsti per gli utenti autorizzati Autodesk. Autodesk non vende né fornisce le informazioni personali ad alcuna entità esterna ad Autodesk o ai suoi business partner autorizzati. Per correggere o aggiornare le informazioni inserite in precedenza, fare clic <a %1>QUI</a> per contattare Autodesk oppure rivolgersi all'ufficio locale Autodesk.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Informativa sulla privacy";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Tutti i diritti riservati."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="Nella maggior parte dei casi, il nuovo numero di serie non verrà visualizzato finché il programma non sarà riavviato con diritti di amministratore.";
var xmsgRebranding2="Per le informazioni su come avviare i programmi con diritti di amministratore, fare riferimento alla documentazione del sistema operativo.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "I campi contrassegnati con <FONT color=red>*</FONT> sono obbligatori.";
var xmsgRegInfoMsg2= "Le informazioni fornite in questa pagina vengono memorizzate insieme alla licenza e verranno utilizzate per la riattivazione e per gli aggiornamenti del prodotto. Assicurarsi di inserire le informazioni corrette in modo da evitare ritardi nell'utilizzo del prodotto.";

var xmsgLicLocationText1 = "Salvare il file di licenza per <b>%1</b> in:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Domande:";

var xmsgAppUsageQ1=	"Per consentire ad Autodesk di comprendere meglio le necessità del settore, vi preghiamo di rispondere alla seguente domanda.";
var xmsgAppUsageQ2=	"Quale delle seguenti opzioni descrive meglio il settore principale della vostra attività?";

var xmsgAppUsageOption51=	"Progettazione di componentistica aerospaziale e automobilistica ";
var xmsgAppUsageOption52=	"Progettazione architettonica ";
var xmsgAppUsageOption53=	"Gestione di edifici e impianti ";
var xmsgAppUsageOption54=	"Costruzione di edifici: uso commerciale ";
var xmsgAppUsageOption55=	"Costruzione di edifici: uso residenziale ";
var xmsgAppUsageOption56=	"Produzione di attrezzature per l'edilizia ";
var xmsgAppUsageOption57=	"Ingegneria civile/Pianificazione del territorio ";
var xmsgAppUsageOption58=	"IT/Medico/Progettazione di attrezzature per uffici ";
var xmsgAppUsageOption67=	"Progettazione di prodotti consumer ";
var xmsgAppUsageOption59=	"Proprietà di edifici aziendali ";
var xmsgAppUsageOption92=	"Difesa ";
var xmsgAppUsageOption93=	"Progettazione di controlli elettrici ";
var xmsgAppUsageOption94=	"Progettazione di impianti elettrici ";
var xmsgAppUsageOption72=	"Ingegneria ambientale ";
var xmsgAppUsageOption95=	"Prodotti metallici assemblati ";
var xmsgAppUsageOption96=	"Progettazione di interni ";
var xmsgAppUsageOption97=	"Progettazione di macchinari ";
var xmsgAppUsageOption98=	"Procurement/Vendita/Marketing settore manufatturiero ";
var xmsgAppUsageOption40=	"Cartografia e progettazione geospaziale ";
var xmsgAppUsageOption41=	"Progettazione di sistemi meccanici (HVAC e tubazioni) ";
var xmsgAppUsageOption42=	"Progettazione di sistemi idraulici e antincendio ";
var xmsgAppUsageOption43=	"Progettazione di centrali elettriche e stabilimenti di trasformazione ";
var xmsgAppUsageOption44=	"Sviluppo immobiliare ";
var xmsgAppUsageOption45=	"Ingegneria strutturale ";
var xmsgAppUsageOption87=	"Telecomunicazioni ";
var xmsgAppUsageOption46=	"Pressofusione e lavorazioni meccaniche ";
var xmsgAppUsageOption47=	"Progettazione di trasporti ";
var xmsgAppUsageOption48=	"Servizi di pubblica utilità: elettricità, energia e gas ";
var xmsgAppUsageOption49=	"Servizi di pubblica utilità: acqua e fognatura ";
var xmsgAppUsageOption99=	"Altro ";

var xmsgWrongCountryCodeMsg=	"Errore: codice paese immesso sconosciuto.";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Versione:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Invierò la richiesta per fax o per telefono"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Effettuare la registrazione per posta.";
var xmsgAccessHereMsg=		"qui.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Desidero ricevere il codice tramite:";
var xmsgReceiveCodeMsg1=     "Riceverò il file di attivazione tramite e-mail"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Attendere la <br>verifica della licenza";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Informazioni sul prodotto"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Sono obbligatori tutti i campi."; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Ottenere una licenza di rete";
var xmsgNSARTBeginMsg1=		"Richiedere un file di attivazione delle licenze di rete tramite:";
var xmsgNSARTBeginMsg2=		"Connessione diretta (tramite Internet)";
var xmsgNSARTBeginMsg3=		"Invia la richiesta per posta elettronica, fax o telefono";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Informazioni server";
var xmsgEditServerHdrMsg2=	"Modello server delle licenze*";
var xmsgEditServerMsg1=		"Immettere le informazioni del server delle licenze.<br>Fare clic sul pulsante Cerca per compilare il campo ID host server.<p>";
var xmsgEditServerMsg2=		"Iniziare con i dati dell'host del server presenti in un file o più file di licenza esistenti.";
var xmsgEditServerRemove=	"Rimuovi";
var xmsgEditServerHostName=	"Nome host server*";
var xmsgEditServerHostID=	"ID host*";
var xmsgEditServerSeat=		"Postazioni*";
var xmsgEditServerSingle=	"Server singolo";
var xmsgEditServerDistributed=	"Server distribuito";
var xmsgEditServerRedundant=	"Server ridondante";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Cerca";
var xmsgEditServerAddServer=	"Aggiungi";
var xmsgEditServerRemoveServer=	"Rimuovi";
var xmsgEditServerTotal=	"Totale:";
var xmsgEditServerExceedMaxServer=	"Nota: è possibile ottenere la licenza per un numero massimo di 20 server distribuiti contemporaneamente. Per ottenere la licenza per un numero maggiore di server, contattare Autodesk.";
var xmsgEditServerSeatError=	"Per le postazioni è necessario specificare solo valori numerici.";

var xmsgConfirmServerMsg=	"Leggere le informazioni riportate di seguito. Fare clic su Avanti per continuare o su Indietro per apportare modifiche.";
var xmsgConfirmServerMsg2=	"Quando si farà clic su Avanti le informazioni verranno inviate ad Autodesk tramite Internet.";
var xmsgConfirmServerHdr2=	"Modello server delle licenze:";
var xmsgConfirmServerHostName=	"Nome host server";
var xmsgConfirmServerHostID=	"ID host";
var xmsgConfirmServerSeat=		"Postazioni";
var xmsgConfirmServerTotal=		"Totale postazioni:";

var xmsgLicErrorHdr=			"Errore di gestione licenze"; 
var xmsgLicErrorInvalidSN=		"Il numero di serie immesso non è valido. Verificare che il numero di serie visualizzato sia corretto. Fare clic su uno dei seguenti collegamenti.";
var xmsgLicReEnterSN=			"Immettere nuovamente il numero di serie e riprovare.";

var xmsgLic113Msg2=				"Il numero complessivo di postazioni assegnate ai server distribuiti è maggiore del numero immesso.";
var xmsgLic113ModifySeats=		"Modifica la distribuzione delle postazioni.";

var xmsgSaveLicenseHdr=			"Licenza/e ricevute";
var xmsgSaveLicenseMsg1=		"Autodesk ha reso disponibili le licenze, che ora devono essere salvate nei file di licenza.<p> <b>Salvare le licenze nei file di licenza</b><p><LI>La <b>posizione consigliata</b> per i file di licenza è una directory \"License\" del server nel percorso di installazione di Autodesk Network License Manager.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Se si dispone di un <b>file di licenza esistente</b>, <b>inserirvi</b> la nuova licenza.<br>Quando si farà clic su Avanti, il sistema inserirà automaticamente le informazioni di licenza nella posizione appropriata del file esistente.</LI>";
var xmsgSaveLicenseMsg2=		"Se il file specificato sopra è un file di licenza esistente:";
var xmsgSaveLicenseMsg3=		"Inserirvi le informazioni della nuova licenza.";
var xmsgSaveLicenseMsg4=		"Sovrascrivere il file di licenza esistente.";
var xmsgSaveLicenseMsg5=		"Correggere gli errori seguenti:";

var xmsgSaveErrorFileNameTooLong=  "ERRORE: il nome del file immesso è troppo lungo.<br>" +
								"Modificarlo e continuare.";
var xmsgSaveErrorNoPermission=	"ERRORE: non si dispone dell'autorizzazione necessaria per salvare il file nella posizione specificata.<br>Salvare il file in una posizione temporanea, ottenere l'autorizzazione, quindi spostare il file nella posizione desiderata.";
var xmsgSaveErrorNoDiskSpace=	"ERRORE: lo spazio disponibile sul disco è insufficiente al salvataggio del file nella posizione specificata.<BR>Salvare il file in una posizione temporanea, creare ulteriore spazio, quindi spostare il file nella posizione desiderata.";
var xmsgSaveErrorInvalidFile=	"ERRORE: impossibile aggiungere la nuova licenza al file specificato senza perdere i dati. Il file specificato potrebbe essere stato creato per computer o modelli di server diversi.<BR>Salvare il nuovo file di licenza con un nome diverso o in un'altra posizione, quindi aggiungerlo al file esistente.";															
var xmsgSaveErrorPathNotExit=	"ERRORE: il percorso specificato non esiste.<BR>Fare clic sul pulsante Sfoglia per individuare o creare il percorso.";
var xmsgSaveErrorPathBlank=		"ERRORE: è necessario specificare un percorso e un nome di file di licenza validi. Specificare il percorso e il nome file nel campo sottostante oppure utilizzare il pulsante Sfoglia per individuarli.";

var xmsgLicAuthConfirmHdr1=		"Attivazione della licenza completata.";
var xmsgLicAuthConfirmHdr2=		"Informazioni sull'host del server delle licenze";
var xmsgLicAuthConfirmMsg1=		"Grazie per aver registrato il prodotto. È possibile stampare le informazioni visualizzate.";
var xmsgLicAuthConfirmDate=		"Data:";

var xmsgLicPathMsg1=			"Sono stati salvati i seguenti file di licenza:";
var xmsgLicPathMsg2=			"I file delle licenze sono stati salvati in:";

var xmsgOtherMethodMsg1NSA=		"Utilizzare un altro metodo per ottenere una licenza autorizzata.";
var xmsgOtherMethodMsg1=		"Utilizzare un altro metodo.";

var xmsgContactAutodeskMsg1=	"Utilizzare uno dei seguenti metodi per contattare Autodesk.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Ottenere un file di licenza tramite e-mail";
var xmsgEmailOptionTitle=		"Effettuare la registrazione tramite e-mail";
var xmsgEmailOptionNSAMsg=		"Le informazioni sulla registrazione e sul server delle licenze sono state salvate automaticamente in un file. Il file deve essere inviato via e-mail al centro di elaborazione automatica delle registrazioni Autodesk™.<p>Una volta inviato il file, si riceveranno una risposta automatica, un file di licenza autorizzata e le istruzioni necessarie per completare il processo.";
var xmsgEmailOptionMsg=			"Le informazioni sulla registrazione e sul server delle licenze sono state salvate automaticamente in un file. Il file deve essere inviato via e-mail al centro di elaborazione automatica delle registrazioni Autodesk™.<p>Una volta inviato il file, si riceveranno una risposta automatica e le istruzioni necessarie per completare il processo.";
var xmsgEmailOptionMsg2=		"Se il sistema e-mail di default utilizzato è in grado di inviare il messaggio su Internet, fare clic su Invia il file, quindi su Avanti. Il file verrà inviato automaticamente.<p>Se non è possibile inviare il messaggio ora, fare clic su Invia il file manualmente in seguito. Verranno fornite le istruzioni necessarie per inviare il file manualmente.";
var xmsgEmailOptionInfo1=		"Invia il file.";
var xmsgEmailOptionInfo2=		"Invia il file manualmente in seguito.";
var xmsgEmailOptionInfo3=		"Invia una copia del messaggio e-mail all'indirizzo e-mail fornito.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Impossibile creare l'e-mail";
var xmsgEmailErrorMsg1=			"Per completare la registrazione via e-mail, allegare il seguente file a un messaggio e-mail:";
var xmsgEmailErrorMsg2=			"Inviare l'e-mail a %1.";
var xmsgEmailErrorMsg3=			"Il file è reperibile nella seguente posizione:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Modificare le informazioni sul cliente";
var xmsgLocalHEREInfo=			"Per modificare le informazioni sul cliente, contattare il rivenditore autorizzato Autodesk o fare clic sul seguente collegamento relativo al proprio paese o regione.";
var xmsgLocalHEREUS=			"America";
var xmsgLocalHEREEMEA=			"Europa, Medio Oriente, Africa";
var xmsgLocalHEREAPAC=			"Asia/Pacifico";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"?";
var xmsgHelpUpgradeMsg=			"Se si sta registrando o attivando un aggiornamento di una versione precedente, è necessario selezionare la seguente casella; verrà quindi richiesto il numero di serie della versione che si desidera aggiornare.";
var xmsgHelpUpgradeRequiredTitle=	"Digitare il numero di serie della precedente versione del prodotto (obbligatorio per l'aggiornamento)";
var xmsgHelpUpgradeRequiredMsg=	"Questo è il numero di serie della versione precedente del software. Il numero di serie è reperibile sia mediante la finestra di dialogo ? > Informazioni su all'interno del software che sulla confezione del prodotto.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Non è stato immesso %1. Immetterlo per ricevere l'attivazione usando tale metodo.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Numero di serie/ID gruppo"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Il numero di serie si trova sulla confezione del prodotto o nell'e-mail Informazioni sugli aggiornamenti e sulle licenze Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Chiave di prodotto";
var xmsgHelpProductKeyMsg=    "La chiave di prodotto si trova vicino al numero di serie sulla confezione del prodotto o nell'e-mail Informazioni sugli aggiornamenti e sulle licenze Autodesk ."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Errore di connessione (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Errore di registrazione (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Già registrato (9)";
var xmsgRT10ExceededAuths=				"Limite autorizzazioni superato (10)";
var xmsgRT12StolenSN=					"Numero di serie rubato (12)";
var xmsgRT18OldSNInvalid=				"Numero di serie precedente non valido (18)";
var xmsgRT20DataError=					"Errore dati (20)";
var xmsgRT21CustIDTelErr=				"Errore ID cliente/Telefono (21)";
var xmsgRT22NetworkInstallation=		"Errore installazione su rete (22)";
var xmsgRT900SystemNotResponding=		"Il sistema non risponde (900)";
var xmsgRTCustID=						"ID cliente";
var xmsgRTCustIDConfirm=				"Conferma identificazione";
var xmsgRTNewSerialNumber=				"Informazioni sul nuovo numero di serie";
var xmsgRTNoNewSN=						"Errore di transazione di acquisto";
var xmsgRTPurchAuthFailed=				"Errore di attivazione";
var xmsgRTPurchConfirmOther=			"Conferma acquisto";
var xmsgRTPurchConfirmPerm=				"Conferma acquisto: registrato e attivato";
var xmsgRTPurchConfirmReg=				"Conferma acquisto: registrato ma non attivato";
var xmsgRTPurchConfirmRegVol=			"Conferma acquisto: registrato";
var xmsgRTPurchConfirmRent=				"Conferma acquisto: noleggio attivo e registrato";
var xmsgRTPurchConfirmUnReg=			"Conferma acquisto: non registrato né attivato";
var xmsgRTPurchConnectionFailed=		"Errore di connessione acquisto";
var xmsgRTPurchaseError=				"Errore di acquisto";
var xmsgRTSNMismatch=					"Errore di transazione di acquisto: il numero di serie non corrisponde";
var xmsgRTSUNOldSNInvalid=				"Numero di serie precedente non valido - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Esci";

var xmsgCustIDMainTitle=	"Identificazione cliente";
var xmsgCustIDTitle1=		"ID cliente:";
var xmsgCustIDText2=		"Immettere l'ID cliente e il numero di telefono nei campi riportati di seguito. Se non si dispone dell'ID cliente, lasciare vuoti entrambi i campi.<p> ";
var xmsgCustIDText3=		"Nota: se si sta attivando nuovamente il prodotto, l'immissione dell'ID cliente è necessaria.";
var xmsgCustIDText3NSA=		"Nota: se si sta autorizzando nuovamente il prodotto, l'immissione dell'ID cliente è necessaria.";
var xmsgCustIDTitle2=		"Numero di telefono:";
var xmsgCustIDTelEx4=		"(esempio: 03-111-1234)";
var xmsgRegCustIDTel=		"L'ID cliente e il numero di telefono immessi non corrispondono. Fare clic su uno dei seguenti collegamenti.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"I record indicano che sono disponibili %1 postazioni %2 valide.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Il numero di serie immesso non è valido";
var xmsgErr12APAC=				"<p>Questo numero di serie non è valido e non può essere attivato. Inviare un'e-mail a <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Gentile signore/signora,</p><p>grazie per aver provato a registrare il prodotto software Autodesk&#0174; o Discreet&#0153; con  Autodesk.</p><p>Purtroppo i nostri dati indicano che il numero di serie per il prodotto software Autodesk&#0174; o Discreet&#0153; che si è cercato di registrare non è valido o è un numero di serie appartenente a una copia pirata nota del prodotto software; di conseguenza il prodotto software Autodesk&#0174; o Discreet&#0153; che si sta tentando di utilizzare non è autorizzato.</p><p>Le licenze per l'utilizzo dei prodotti software Autodesk&#0174; possono essere acquistate dai rivenditori autorizzati Autodesk; visitare la pagina <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> per l'elenco dei rivenditori autorizzati Autodesk o degli uffici Autodesk più vicini. L'utilizzo di software legale rappresenta l'unico modo per usufruire di tutti i vantaggi derivanti dall'utilizzo del software ed evitare possibili conseguenze di natura civile e penale derivanti dall'utilizzo e/o dalla riproduzione illegale del software.</p><p>Le licenze per l'utilizzo dei prodotti software Discreet&#0153; possono essere acquistate dai rivenditori autorizzati Discreet; visitare la pagina <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> per l'elenco dei rivenditori autorizzati Discreet o degli uffici Discreet più vicini. L'utilizzo di software legale rappresenta l'unico modo per usufruire di tutti i vantaggi derivanti dall'utilizzo del software e per evitare possibili conseguenze di natura civile e penale derivanti dall'utilizzo e/o dalla riproduzione illegale del software.</p><p>Pertanto Autodesk chiede di interrompere immediatamente l'utilizzo del prodotto software non autorizzato che si è tentato di registrare, di eliminare tutte le copie memorizzate sull'hardware del computer e di distruggere i supporti contenenti il prodotto software. Pur confidando nel fatto che tali azioni verranno intraprese volontariamente, Autodesk si riserva tutti i diritti in relazione a tale avvenimento, tra cui quello di inoltrare i dettagli dell'utente alla Business Software Alliance (“BSA”).</p><p>Per eventuali chiarimenti o se si ritiene di aver ricevuto questo messaggio per errore, è possibile contattare Autodesk al seguente indirizzo: <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p><p>Per fornire le informazioni relative all'utilizzo o alla vendita illegale del software, contattare l'ufficio locale Autodesk o la BSA alla pagina <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Grazie</p>";
var xmsgErr12US=				"<p>Gentile signore/signora,</p><p>si è tentato di registrare il prodotto software con Autodesk o Discreet.</p><p>Purtroppo i nostri dati indicano che il numero di serie per il prodotto software Autodesk&#0174; o Discreet&#0153; che si è cercato di registrare non è valido o è un numero di serie appartenente a una copia pirata nota del prodotto software; di conseguenza il prodotto software Autodesk&#0174; o Discreet&#0153; che si sta tentando di utilizzare non è autorizzato.</p><p>Per gli utenti Autodesk, le licenze per l’utilizzo dei prodotti software Autodesk&#0174; possono essere acquistate presso i rivenditori autorizzati Autodesk; visitare la pagina <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> per l’elenco dei rivenditori autorizzati Autodesk più vicini. L'utilizzo di software legale rappresenta l'unico modo in cui per usufruire di tutti i vantaggi derivanti dall'utilizzo del software e per evitare possibili conseguenze di natura civile e penale derivanti dall'utilizzo e/o dalla riproduzione illegale del software.</p><p>Per gli utenti Discreet&#0153;, le licenze per l’utilizzo dei prodotti software Discreet&#0153; possono essere acquistate presso i rivenditori autorizzati Discreet; visitare la pagina <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> per l’elenco dei rivenditori autorizzati Discreet o degli uffici Discreet più vicini. L'utilizzo di software legale rappresenta l'unico modo per usufruire di tutti i vantaggi derivanti dall'utilizzo del software E per evitare possibili conseguenze di natura civile e penale derivanti dall'utilizzo e/o dalla riproduzione illegale del software.</p><p>È necessario interrompere immediatamente l’utilizzo del prodotto software non autorizzato che si è tentato di registrare, di eliminare tutte le copie memorizzate sull'hardware del computer e di distruggere i supporti contenenti il prodotto software. Pur confidando nel fatto che tali azioni verranno intraprese volontariamente, Autodesk si riserva tutti i diritti in relazione a tale avvenimento, tra cui quello di inoltrare i dettagli dell'utente alla Business Software Alliance (“BSA”).</p><p>Per eventuali chiarimenti o se si ritiene di aver ricevuto questo messaggio per errore, è possibile contattare Autodesk all'indirizzo: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>Per fornire le informazioni relative all'utilizzo o alla vendita illegale del software, contattare l'ufficio locale o la BSA alla pagina <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Grazie</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFKsDNKlvIK/U
// SIG // FxGkRt3WNF7Ll2ffoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFG55CS6UbYrakeqtfPF+gpbQ4I9BMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYBn
// SIG // e667sMzFFvP+mw7xQaM4G1eoBq/T6d7BeNHGb1AlmvVg
// SIG // DGI14Fq7U4o7/+6X2OEYPM1qJ+fkHuPrCYQP0Lk2IpQG
// SIG // qM0jjMMJjEqF8yIsc1y5nFEf2jg+61oG5NwrJuL7AUc8
// SIG // U7vxBVYv0RJc4W9J2A77XFLdCpEh4ZjOfURrPqGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyODU3
// SIG // WjAjBgkqhkiG9w0BCQQxFgQU10Jj5D4L5UGJJQuhuA8K
// SIG // l3b1PF0wDQYJKoZIhvcNAQEBBQAEgYBx/MYSuaf3oi0K
// SIG // KJsiYDGcocKJhxML1QcmnIiZb5Jt+/r51i7mLoy4Shkl
// SIG // sOwQ7eI9quqa8afO1PyEjnDKQ5nKbv/ISXknGcJjzdao
// SIG // rQoduG9N8aQJe6BrwQtR5CXvJFs7ve2wp9KbetGVfSbF
// SIG // VMfYIIvpSvTRaaGFGp7cAENRog==
// SIG // End signature block
